function [x,X,k] = tangentna(f,df,x0,tol,N)
% tangentna izvede tangentno metodo za dano funkcijo, njen odvod in
% zacetni priblizek. Iteracije se izvajajo dokler ne presezemo stevila
% korakov N oz. dokler je absolutna razlika dveh zaporednih približkov 
% večja od tolerance 
% (ustavimo se torej, ko prvič velja 
% abs[(trenutni priblizek)-(prejsni priblizek)] <= tol.
%
% [x,X,k] = tangentna(f,df,x0,tol,N)
%
% Vhodni podatki:
%  f    dana funkcija,
%  df   prvi odvod funkcije f,
%  x0   zacetni priblizek,
%  tol  toleranca absolutnega ujemanja dveh zaporednih priblizkov
%  N    maksimalno stevilo korakov metode.
%
% Izhodni podatki:
%  x    zadnji priblizek izracunan z tangentno metodo,
%  X    seznam vseh priblizkov izracunanih z tangentno metodo,
%  k    stevilo opravljenih korakov metode.

x_old = x0;
X = x_old;
for i = 1:N
    x_new = x_old - f(x_old)/df(x_old);
    X = [X,x_new];
    if abs(x_old - x_new) <= tol
        x = x_new;
        k = i;
        return
    else
        x_old = x_new;
    end
    x = x_new;
end
k = N;
end