function [x,X,k] = sekantna(f,x0,x1,tol,N)
% sekantna izvede sekantno metodo za dano funkcijo in
% zacetna priblizka. Iteracije se izvajajo dokler ne presezemo stevila
% korakov N oz. dokler je absolutna razlika dveh zaporednih približkov večja od tolerance 
% (ustavimo se torej, ko prvič velja abs[(trenutni priblizek)-(prejsni priblizek)] <= tol.
%
% [x,X,k] = sekantna(f,x0,x1,tol,N)
%
% Vhodni podatki:
%  f    funkcija,
%  x0   zacetni priblizek,
%  x1   zacetni priblizek,
%  tol  toleranca absolutnega ujemanja dveh zaporednih priblizkov
%  N    maksimalno stevilo korakov iteracije.
%
% Izhodni podatki:
%  x    zadnji priblizek izracunan s sekantno metodo,
%  X    seznam vseh priblizkov izracunanih s sekantno metodo,
%  k    stevilo opravljenih korakov metode.

x_old_old = x0;
x_old = x1;
X = [x_old_old,x_old];
for i = 1:N
    x_new = x_old - (f(x_old)*(x_old - x_old_old))/(f(x_old) - f(x_old_old));
    X = [X,x_new];
    if abs(x_old - x_new) <= tol
        x = x_new;
        k = i;
        return
    else
        x_old_old = x_old;
        x_old = x_new;
    end
    x = x_new; 
end
k = N;
end