function [L,U] = lubp(A)
% Opis:
%  lubp izracuna LU razcep A = LU matrike A brez pivotiranja
%
% Definicija:
%  [L,U] = lubp(A)
%
% Vhodni podatek:
%  A    kvadratna matrika (z nesingularnimi vodilnimi podmatrikami)
%
% Izhodna podatka:
%  L    spodnje trikotna matrika z enkami na diagonali,
%  U    zgornje trikotna matrika
[n,n] = size(A);
for i = 1:n
    for j = i+1:n
        A(j,i) = A(j,i) / A(i,i);
    end
    for k = i+1:n
        for l = i+1:n
            A(k,l) = A(k,l) - A(k,i)*A(i,l);
        end
    end
end
L = tril(A);
for i = 1:n
    L(i,i) = 1;
end
U = triu(A);
end