function [Q, R] = qr_givens(A)
%QR_GIVENS QR decomposition using Givens rotations
%   [Q,R] = qr_givens(A)
%   A : m-by-n matrix
%   Q : m-by-m orthogonal matrix
%   R : m-by-n upper triangular matrix

[m, n] = size(A);

R = A;
Q = eye(m);

for j = 1:n
    for i = m:-1:(j+1)
        
        a = R(i-1, j);
        b = R(i, j);
        
        if b ~= 0

            r = hypot(a, b);   % stable sqrt(a^2 + b^2)
            c = a / r;
            s = -b / r;
            
            G = [c -s; s c];
            R([i-1 i], j:n) = G * R([i-1 i], j:n);
            

            Q(:, [i-1 i]) = Q(:, [i-1 i]) * G';
        end
        
    end
end
end
