function [odmik] = fraktal(g1, g2, x, y)
    toleranca = 1e-5;

    N = 100;

    resitev = [1 0];

    i = 1;
    
    prib = [x y];
    partial = zeros(N, 2);
    while (i <= N)
        prib2 = zeros(1, 2);
        prib2(1) = g1(prib(1, 1), prib(1, 2));
        prib2(2) = g2(prib(1, 1), prib(1, 2));

        partial(i, :) = prib;

        if norm(prib2 - prib) < toleranca
            prib = prib2;
            break
        endif

        prib = prib2;
        i++;

    end
    odmik = norm(prib - [x y]);
endfunction