% ==============================
% === NAVADNA ITERACIJA ========
% =============================
clc
disp('=== NAVADNA ITERACIJA ===')


G = @(v) [
    nthroot(1 + 5*v(1)*v(2) - v(2)^5, 5);
    (1 - v(1)^2)/exp(v(2)^2)
];


x0 = [0.5; -0.5];
tol = 1e-8;
N = 100;

[x, X, k] = iteracija(G, x0, tol, N);


disp('Final approx')
disp(x)

% disp('ALL approx:')
% disp(X)

disp('Number of steps:')
disp(k)

disp('Error:')
disp(abs([1; 0] - x))

% spektralni radij ???

alpha = [1; 0];

syms x y

g1 = (1 + 5*x*y - y^5)^(1/5);
g2 = (1 - x^2)*exp(-y^2);

G = [g1; g2];

JG = jacobian(G, [x y]);

JG_num = double(subs(JG, {x, y}, {alpha(1), alpha(2)}))
rho = max(abs(eig(JG_num)))

% ==============================
% === NEWTONOVA METODA ========
% =============================

disp('=== NEWTONOVA METODA ===')

F = @(v) [
     v(1)^5 + v(2)^5 - 5*v(1)*v(2) - 1;
    v(1)^2 + v(2)*exp(v(2)^2) - 1 ];



syms x y

Fsym = [
    x^5 + y^5 - 5*x*y - 1;
    x^2 + y*exp(y^2) - 1
];


Jsym = jacobian(Fsym,[x y]);
JF = matlabFunction(Jsym,'Vars',{[x;y]});


x0  = [0.5; -0.5]; 
tol = 1e-5;
N   = 100;

[x, X, k] = newton(F, JF, x0, tol, N);

disp('Final approx')
disp(x)

%  disp('ALL approx:')
% disp(X)

disp('Number of steps:')
disp(k)

disp('Error:')
disp(abs([1; 0] - x))


% ==============================
% === BROYDENOVA METODA ========
% =============================
clear
disp('=== BROYDENOVA METODA ===')
F = @(v) [
     v(1)^5 + v(2)^5 - 5*v(1)*v(2) - 1;
    v(1)^2 + v(2)*exp(v(2)^2) - 1 ];



syms x y

Fsym = [
    x^5 + y^5 - 5*x*y - 1;
    x^2 + y*exp(y^2) - 1
];


Jsym = jacobian(Fsym,[x y]);
JF = matlabFunction(Jsym,'Vars',{[x;y]});


x0  = [0.5; -0.5]; 
tol = 1e-5;
N   = 100;

JF_numeric = matlabFunction(Jsym, 'Vars', {[x; y]});


B0 = JF_numeric(x0);

[x, X, k] = broyden(F, B0, x0, tol, N);

disp('Final approx')
disp(x)

% disp('ALL approx:')
% disp(X)

disp('Number of steps:')
disp(k)

disp('Error:')
disp(abs([1; 0] - x))