function [x, X, k] = broyden(f, B0, x0, tol, N)
    x = x0;
    B = B0;
    X = x;

    for k = 1:N
        fx = f(x);
        dx = -B \ fx;  
        % disp('xnew:')
        x_new = x + dx;

        X = [X, x_new];

        if norm(dx, 2) <= tol
            x = x_new;
            return;
        end

        y = f(x_new) - fx;
        B = B + (f(x_new)*dx') / (dx' * dx);

        x = x_new;
    end
end
