function [V,p] = CholPivot(A)
% Opis:
%  CholPivot izracuna razcep Choleskega z diagonalnim pivotiranjem.
%
% Definicija:
%  [V,p] = CholPivot(A)
%
% Vhodni podatki:
%  A    simetricna pozitivno definitna matrika velikosti nxn
%
% Izhodni podatki:
%  V    spodnje trikotna matrika (faktor Choleskega),
%  p    seznam, ki doloca permutacijsko matriko P (index i elementa v seznamu
%       p doloca vrstico matrike P, ki ima enico na p(i)-tem mestu)
[n,n] = size(A);
V = zeros(n);
p = 1:n;
for k = 1:n
    q_value = max(diag(A(k:n,k:n)));
    for i = k:n
        if A(i,i) == q_value
            q = i;
            break
        end
    end
    % zamenjava stolpcev v A
    tmp = A(:,k);
    A(:,k) = A(:,q);
    A(:,q) = tmp;
    % zamenhjava vrstic v V
    tmp = V(k,:);
    V(k,:) = V(q,:);
    V(q,:) = tmp;
    % zamenjava vrstic v A
    tmp = A(k,:);
    A(k,:) = A(q,:);
    A(q,:) = tmp;
    % zamenjava pozicije pivota
    tmp = p(k);
    p(k) = p(q);
    p(q) = tmp;

    %razcep choleskega
    V(k,k) = sqrt(A(k,k));
    V(k+1:n,k) = A(k+1:n,k)/V(k,k);
    A(k+1:n,k+1:n) = A(k+1:n,k+1:n) - V(k+1:n,k) * V(k+1:n,k)';

end
end
