function [x,X,k] = sekantna(f,x0,x1,tol,N)
% sekantna izvede sekantno metodo za dano funkcijo in
% zacetna priblizka. Iteracije se izvajajo dokler ne presezemo stevila
% korakov N oz. dokler je absolutna razlika dveh zaporednih približkov večja od tolerance 
% (ustavimo se torej, ko prvič velja abs[(trenutni priblizek)-(prejsni priblizek)] <= tol.
%
% [x,X,k] = sekantna(f,x0,x1,tol,N)
%
% Vhodni podatki:
%  f    funkcija,
%  x0   zacetni priblizek,
%  x1   zacetni priblizek,
%  tol  toleranca absolutnega ujemanja dveh zaporednih priblizkov
%  N    maksimalno stevilo korakov iteracije.
%
% Izhodni podatki:
%  x    zadnji priblizek izracunan s sekantno metodo,
%  X    seznam vseh priblizkov izracunanih s sekantno metodo,
%  k    stevilo opravljenih korakov metode.
	X = zeros(1, N+2)
	X(1) = x0
	X(2) = x1
	for k=1:N
		% X(k) je predprejšnji, X(k+1) je prejšnji in X(k+2) je naslednji, ki ga zdaj računamo
		X(k+2) = X(k+1) - f(X(k+1))*(X(k+1)-X(k))/(f(X(k+1))-f(X(k)))
		if abs(X(k+1)-X(k+2)) <= tol
			break
		end
	end
	x = X(k+2)
	X = X(1:k+2)
end
