function risi_kroznici(T)
% RISI_KROZNICI narise trikotnik ter vcrtano in ocrtano kroznico
% skupaj s srediscema. Trikotnik je podan z matriko T velikosti 2x3,
% kjer prva vrstica doloca abscise, druga pa ordinate ogljisc trikotnika.

%% OCRTANA KROZNICA
[SD1, sd1] = simetrala_daljice(T(:,1),T(:,2))
[SD2, sd2] = simetrala_daljice(T(:,3),T(:,1))
osred = presek_premic(SD1,SD2,sd1,sd2)
oradij = norm(T(:,1)-osred)
%% VCRTANA KROZNICA
[SK1, sk1] = simetrala_kota(T(:,1),T(:,2),T(:,3))
[SK2, sk2] = simetrala_kota(T(:,3),T(:,1),T(:,2))
vsred = presek_premic(SK1,SK2,sk1,sk2)
koefvsred = [(T(:,2)-T(:,1))(2) ; -(T(:,2)-T(:,1))(1)]
tocka = presek_premic(vsred, T(:,2), koefvsred, T(:,1)-T(:,2))
vradij = norm(tocka-vsred)
%% RISANJE
hold on
t = [0:0.001:1]
pts = t.*(T(:,2)-T(:,1))+T(:,1)
plot(pts(1,:), pts(2,:))
pts = t.*(T(:,3)-T(:,1))+T(:,1)
plot(pts(1,:), pts(2,:))
pts = t.*(T(:,2)-T(:,3))+T(:,3)
plot(pts(1,:), pts(2,:))
plot(osred(1), osred(2))
pts = t.*sd1+SD1
plot(pts(1,:), pts(2,:))
pts = t.*sd2+SD2
plot(pts(1,:), pts(2,:))
plot(SD1(1), SD1(2))
plot(SD2(1), SD2(2))
plot(cos(t*pi*2)*oradij+osred(1), sin(t*pi*2)*oradij+osred(2))
plot(vsred(1),vsred(2))
pts = t.*koefvsred+vsred
plot(pts(1,:), pts(2,:))
pts = t.*sk2+SK2
plot(pts(1,:), pts(2,:))
plot(cos(t*pi*2)*vradij+vsred(1), sin(t*pi*2)*vradij+vsred(2))
axis("equal")
hold off
end
