function c = regula_falsi(f,a,b,n)
% Funkcija računa približke za ničlo funkcije f na intervalu [a,b] z metodo Regula falsi

% Vhodni podatki:
%   f: dana funkcija
%   a,b: krajišči intervala
%   n: koliko korakov metode naj se izvede (oz. koliko približkov naj
%   se izračuna)
% Izhodni podatek:
%   c: n-ti približek za ničlo funkcije f
	c = (f(b)*a-f(a)*b)/(f(b)-f(a))
	if n == 1
		return
	end
	if f(a) <= 0 && f(c) >= 0 || f(a) >= 0 && f(c) <= 0
		c = regula_falsi(f, a, c, n-1)
	else
		c = regula_falsi(f, c, b, n-1)
	end
end

