function [A, n1, ninf, nfro, n2min, n2max, n2, uspeh] = prvaa(n)
  A = diag([2:2:2*n]*-1) + diag([n-1:-1:1], 1) + diag([n-1:-1:1], -1)
  n1 = norm(A, 1)
  ninf = norm(A, "Inf")
  nfro = norm(A, "Fro")
  n2min = max([nfro/sqrt(n), ninf/sqrt(n), n1/sqrt(n)])
  n2max = min([nfro, sqrt(n)*ninf, sqrt(n)*n1, sqrt(n1*ninf)])
  n2 = norm(A, 2)
  knlv = sqrt(max(eig(transpose(A)*A)))
  uspeh = abs(knlv-n2)/n2 < 0.000001 && abs(max(svd(A))-n2)/n2 < 0.000001
end
