function [x,X,k] = newton(f,Jf,x0,tol,N)
% Opis:
%  newton izvede Newtonovo metodo za resevanje sistema nelinearnih enacb. Iteracije se izvajajo dokler ne presezemo stevila
%  korakov N oz. dokler je druga norma razlike dveh zaporednih približkov večja od tolerance
%  (ustavimo se torej, ko prvič velja norm[(trenutni priblizek)-(prejsni priblizek)] <= tol.
%
% Definicija:
%  [x,X,k] = newton(f,Jf,x0,tol,N)
%
% Vhodni podatki:
%  f    preslikava, ki doloca nelinearni sistem f(x) = 0,
%  Jf   Jacobijeva matrika preslikave f,
%  x0   zacetni priblizek (stolpec),
%  tol  toleranca ujemanja dveh zaporednih priblizkov,
%  N    maksimalno stevilo korakov iteracije (privzeta vrednost je 100)
%
% Izhodni podatek:
%  x    koncni priblizek za resitev sistema f(x) = 0
%  X    matrika, ki vsebuje vse izracunane priblizke (vkljucno z x0)
%  k    stevilo izvedenih korakov metode
  assert(width(x0), 1);
  X = zeros(height(x0), N+1);
  X(:,1) = x0;
  for k=1:N
  % X(k) je prejšnji, X(k+1) je naslednji; ta, ki ga zdaj računamo
    X(:,k+1) = X(:,k) + ((Jf(X(:,k)))\(-f(X(:,k))));
    if norm(X(:,k)-X(:,k+1)) <= tol;
      break
    end
  end
  x = X(:,k+1);
  X = X(:,1:k+1);
end
