function [L, U] = lubp(A)
% Opis:
%  lubp izracuna LU razcep A = LU matrike A brez pivotiranja
%
% Definicija:
%  [L,U] = lubp(A)
%
% Vhodni podatek:
%  A    kvadratna matrika (z nesingularnimi vodilnimi podmatrikami)
%
% Izhodna podatka:
%  L    spodnje trikotna matrika z enkami na diagonali,
%  U    zgornje trikotna matrika
A = lubpr(A)
U = triu(A)
L = tril(A)
L = (ones(length(L))-diag(ones(length(L), 1))).*L + diag(ones(length(L), 1))
end
