function [x,X,k] = halley(f,df,ddf,x0,tol,N)
% halley izvede Halleyevo metodo za dano funkcijo, njen prvi in drugi odvod in
% zacetni priblizek. Iteracije se izvajajo dokler ne presezemo stevila
% korakov N oz. dokler je absolutna razlika dveh zaporednih približkov večja od tolerance 
% (ustavimo se torej, ko prvič velja abs[(trenutni priblizek)-(prejsni priblizek)] <= tol.
%
% [x,X,k] = halley(f,df,ddf,x0,tol,N)
%
% Vhodni podatki:
%  f    dana funkcija,
%  df   prvi odvod funkcije f,
%  ddf  drugi odvod funkcije f,
%  x0   zacetni priblizek,
%  tol  toleranca absolutnega ujemanja dveh zaporednih priblizkov
%  N    maksimalno stevilo korakov metode.
%
% Izhodni podatki:
%  x    zadnji priblizek izracunan z Halleyevo metodo,
%  X    seznam vseh priblizkov izracunanih z Halleyevo metodo,
%  k    stevilo opravljenih korakov metode.
	X = zeros(1, N+1)
	X(1) = x0
	for k=1:N
		% X(k) je prejšnji X(k+1) je naslednji; ta, ki ga zdaj računamo
		% https://jankoslavic.github.io/pypinm.io/resevanje-enacb.html
		X(k+1) = X(k) - 2*f(X(k))*df(X(k))/(2*df(X(k))^2-f(X(k))*ddf(X(k)))
		if abs(X(k)-X(k+1)) <= tol
			break
		end
	end
	x = X(k+1)
	X = X(1:k+1)
end
