function [Q,R]=givens(A)
% givens izvede QR razcep z Givensovimi rotacijami
%
% Definicija:
% [Q,R]=givens(A)
%
% Vhodni podatki:
%  A   mxn matrika
%
% Izhodni podatek:
%  Q   mxm ortogonalna
%  R   mxn zgornje trapezna
m = height(A);
n = width(A);
R = A;
Q = eye(m);
for j=1:n
    for i=m:-1:(j+1)
      a = R(i-1, j);
      b = R(i, j);
      if b ~= 0
        r = sqrt(a^2 + b^2);
        c = a / r;
        s = -b / r;
        G = [c -s; s c];
        R([i-1 i], j:n) = G * R([i-1 i], j:n);
        Q(:, [i-1 i]) = Q(:, [i-1 i]) * G';
      end
    end
  end
end
