function [x, X, k] = broyden(f, B0, x0, tol, N)
% Opis:
%  broyden izvede Broydenovo metodo za resevanje sistema nelinearnih enacb.
%  Iteracije se izvajajo dokler ne presezemo stevila
%  korakov N oz. dokler je druga norma razlike dveh zaporednih približkov večja od tolerance
%  (ustavimo se torej, ko prvič velja norm[(trenutni priblizek)-(prejsni priblizek)] <= tol.
%
% Definicija:
% [x,X,k] = broyden(f,B0,x0,tol,N)
%
% Vhodni podatki:
%  f    preslikava, ki doloca nelinearni sistem f(x) = 0,
%  B0   zacetni priblizek za Broydenovo matriko,
%  x0   zacetni priblizek (stolpec),
%  tol  toleranca relativnega ujemanja dveh zaporednih priblizkov,
%  N    maksimalno stevilo korakov iteracije
%
% Izhodni podatek:
%  x    koncni priblizek za resitev sistema f(x) = 0
%  X    matrika, ki vsebuje vse izracunane priblizke (vkljucno z x0)
%  k    stevilo izvedenih korakov metode
  x = x0;
  B = B0;
  X = x;
  for k = 1:N
    fx = f(x);
    dx = -B \ fx;
    xnov = x + dx;
    X = [X, xnov];
    if norm(dx, 2) <= tol
      x = xnov;
      return;
    end
    y = f(xnov) - fx;
    B = B + (f(xnov)*dx') / (dx' * dx);
    x = xnov;
  end
end
