function [V] = altchol (A)
  n = width(A)
  V = zeros(n, n)
  for k=1:n
    V(k,k) = sqrt(A(k, k))
    V(k+1:n,k) = A(k+1:n,k)/V(k, k)
    A(k+1:n, k+1:n) = A(k+1:n, k+1:n) - V(k+1:n, k)*V(k+1:n,k)'
  endfor
endfunction
