function [V,p] = CholPivot(A)
% Opis:
%  CholPivot izracuna razcep Choleskega z diagonalnim pivotiranjem.
%
% Definicija:
%  [V,p] = CholPivot(A)
%
% Vhodni podatki:
%  A    simetricna pozitivno definitna matrika velikosti nxn
%
% Izhodni podatki:
%  V    spodnje trikotna matrika (faktor Choleskega),
%  p    seznam, ki doloca permutacijsko matriko P (index i elementa v seznamu
%       p doloca vrstico matrike P, ki ima enico na p(i)-tem mestu)
n = width(A)
V = zeros(n, n)
p = 1:n
for k=1:n
  [maxval, maxidx] = max(diag(A(k:n, k:n)))
  maxidx = maxidx + k - 1
  A(:, [k, maxidx]) = A(:, [maxidx, k])
  V([k, maxidx], :) = V([maxidx, k], :)
  A([k, maxidx], :) = A([maxidx, k], :)
  p([k, maxidx]) = p([maxidx, k])
  V(k,k) = sqrt(A(k, k))
  V(k+1:n,k) = A(k+1:n,k)/V(k, k)
  A(k+1:n, k+1:n) = A(k+1:n, k+1:n) - V(k+1:n, k)*V(k+1:n,k)'
  endfor
end



